/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tanukidecor.util.MultiblockHandler;
import tanukidecor.util.ShapeBuilder;
import tanukidecor.util.ShapeUtils;

public class RotatingBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected final Map<BlockState, VoxelShape> blockShapes = new HashMap<BlockState, VoxelShape>();
    protected final ShapeBuilder shapeBuilder;

    public RotatingBlock(BlockBehaviour.Properties pProperties, ShapeBuilder shapeBuilder) {
        super(pProperties);
        this.shapeBuilder = shapeBuilder;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.precalculateShapes();
    }

    protected void precalculateShapes() {
        this.blockShapes.clear();
        for (BlockState blockState : this.f_49792_.m_61056_()) {
            this.blockShapes.put(blockState, (VoxelShape)this.shapeBuilder.apply(blockState));
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.blockShapes.get(pState);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean waterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (pLevel.m_8055_(pCurrentPos).m_60713_((Block)this) && !pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            pLevel.m_46961_(pCurrentPos, true);
            return pState.m_60819_().m_76188_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public static ShapeBuilder createShapeBuilder(VoxelShape shape) {
        return blockState -> {
            Direction facing = (Direction)blockState.m_61143_((Property)f_54117_);
            return ShapeUtils.rotateShape(MultiblockHandler.ORIGIN_DIRECTION, facing, shape);
        };
    }

    @Nullable
    public BlockState getStateForWallPlacement(BlockPlaceContext context) {
        boolean waterlogged;
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean bl = waterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
        if (context.m_43719_().m_122434_() != Direction.Axis.Y) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_43719_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        }
        return null;
    }

    public boolean canSurviveOnWall(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos supportingPos = pos.m_121945_(facing.m_122424_());
        BlockState supportingState = level.m_8055_(supportingPos);
        return supportingState.m_60783_((BlockGetter)level, supportingPos, facing);
    }
}

