/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tanukidecor.block.storage.IDelegateProvider;

public class TallBlock
extends Block
implements SimpleWaterloggedBlock,
IDelegateProvider {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected final VoxelShape upperShape;
    protected final VoxelShape lowerShape;
    protected final Map<BlockState, VoxelShape> multiblockShapes = new HashMap<BlockState, VoxelShape>();

    public TallBlock(VoxelShape upperShape, VoxelShape lowerShape, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.upperShape = upperShape;
        this.lowerShape = lowerShape;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.precalculateShapes();
    }

    protected void precalculateShapes() {
        this.multiblockShapes.clear();
        VoxelShape doubleBlockShape = this.createDoubleBlockShape();
        for (BlockState blockState : this.f_49792_.m_61056_()) {
            double offset = blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER ? 0.0 : 1.0;
            VoxelShape shape = doubleBlockShape.m_83216_(0.0, offset, 0.0);
            this.multiblockShapes.put(blockState, shape);
        }
    }

    protected VoxelShape createDoubleBlockShape() {
        return Shapes.m_83110_((VoxelShape)this.upperShape, (VoxelShape)this.lowerShape.m_83216_(0.0, -1.0, 0.0));
    }

    public VoxelShape getBlockShape(BlockState blockState) {
        return blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER ? this.upperShape : this.lowerShape;
    }

    public VoxelShape getMultiblockShape(BlockState blockState) {
        return this.multiblockShapes.get(blockState);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.f_60443_ ? this.getBlockShape(pState) : Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getMultiblockShape(pState);
    }

    @Override
    public BlockPos getDelegatePos(BlockState blockState, BlockPos blockPos) {
        return blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER ? blockPos : blockPos.m_7494_();
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        boolean waterlogged;
        BlockPos blockpos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean bl = waterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
        if (blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(pContext)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{HALF});
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        DoubleBlockHalf half = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (pFacing.m_122434_() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (pFacing == Direction.UP)) {
            return pFacingState.m_60713_((Block)this) && pFacingState.m_61143_(HALF) != half ? pState : this.m_5888_(pState).m_76188_();
        }
        return half == DoubleBlockHalf.LOWER && pFacing == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? this.m_5888_(pState).m_76188_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        boolean waterlogged = pLevel.m_6425_(pPos.m_7494_()).m_76152_() == Fluids.f_76193_;
        pLevel.m_7731_(pPos.m_7494_(), (BlockState)((BlockState)pState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 3);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER || pLevel.m_8055_(pPos.m_7495_()).m_60713_((Block)this);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_ && pPlayer.m_7500_()) {
            DoublePlantBlock.m_52903_((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (Player)pPlayer);
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }
}

