/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.clock;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tanukidecor.TDRegistry;
import tanukidecor.block.RotatingMultiblock;
import tanukidecor.block.clock.IChimeProvider;
import tanukidecor.block.entity.ClockBlockEntity;
import tanukidecor.util.MultiblockHandler;
import tanukidecor.util.ShapeUtils;

public class SmallClockTowerDialBlock
extends RotatingMultiblock
implements EntityBlock,
IChimeProvider {
    protected final Supplier<SoundEvent> chimeSound;
    protected final Supplier<SoundEvent> tickSound = TDRegistry.SoundReg.CLOCK_TOWER_TICK;
    public static VoxelShape SHAPE = SmallClockTowerDialBlock.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public SmallClockTowerDialBlock(BlockBehaviour.Properties pProperties) {
        super(MultiblockHandler.MULTIBLOCK_2X2X1, SmallClockTowerDialBlock::buildShape, pProperties);
        this.chimeSound = TDRegistry.SoundReg.CLOCK_TOWER_CHIME;
    }

    @Override
    @Nullable
    public SoundEvent getChimeSound(BlockState blockState) {
        return this.chimeSound.get();
    }

    @Override
    @Nullable
    public SoundEvent getTickSound(BlockState blockState) {
        return this.tickSound.get();
    }

    @Override
    public float getChimeVolume(BlockState blockState, RandomSource random, long dayTime) {
        return 4.0f;
    }

    @Override
    public float getTickVolume(BlockState blockState, RandomSource random, long dayTime) {
        return 1.25f;
    }

    @Override
    public int getTickSoundInterval(BlockState blockState) {
        return 40;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (this.getMultiblockHandler().isCenterState(pState)) {
            return ((BlockEntityType)TDRegistry.BlockEntityReg.SMALL_CLOCK_TOWER_DIAL.get()).m_155264_(pPos, pState);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.m_5776_() ? ClockBlockEntity::tick : null;
    }

    public static VoxelShape buildShape(BlockState blockState) {
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        return ShapeUtils.rotateShape(MultiblockHandler.ORIGIN_DIRECTION, facing, SHAPE);
    }
}

