/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class StorageBlockEntity
extends RandomizableContainerBlockEntity {
    protected NonNullList<ItemStack> inventory;
    protected final int rows;
    protected final int slots;

    public StorageBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, int rows) {
        this(pType, pPos, pBlockState, rows, rows * 9);
    }

    public StorageBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, int rows, int slots) {
        super(pType, pPos, pBlockState);
        this.rows = rows;
        this.slots = slots;
        this.inventory = NonNullList.m_122780_((int)slots, (Object)ItemStack.f_41583_);
    }

    public static InteractionResult use(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, SoundEvent openMenuSound) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MenuProvider) {
            MenuProvider blockEntity2 = (MenuProvider)blockEntity;
            player.m_5893_(blockEntity2);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            level.m_5594_(null, pos, openMenuSound, SoundSource.BLOCKS, 1.0f, 0.8f + player.m_217043_().m_188501_() * 0.4f);
        }
        return InteractionResult.CONSUME;
    }

    public static void onRemove(BlockState blockState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity blockEntity2 = (StorageBlockEntity)blockEntity;
            blockEntity2.dropContents();
            level.m_46717_(pos, blockState.m_60734_());
        }
    }

    public void dropContents() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.m_58899_(), this.inventory);
            this.m_6596_();
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public int getRows() {
        return this.rows;
    }

    public int getSlots() {
        return this.slots;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> pItemStacks) {
        this.inventory.clear();
        this.inventory.addAll(pItemStacks);
        this.m_6596_();
    }

    public int m_6643_() {
        return this.getSlots();
    }

    protected Component m_6820_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        switch (this.rows) {
            case 1: {
                return new ChestMenu(MenuType.f_39957_, pContainerId, pInventory, (Container)this, this.rows);
            }
            case 2: {
                return new ChestMenu(MenuType.f_39958_, pContainerId, pInventory, (Container)this, this.rows);
            }
            case 3: {
                return ChestMenu.m_39237_((int)pContainerId, (Inventory)pInventory, (Container)this);
            }
            case 4: {
                return new ChestMenu(MenuType.f_39960_, pContainerId, pInventory, (Container)this, this.rows);
            }
            case 5: {
                return new ChestMenu(MenuType.f_39961_, pContainerId, pInventory, (Container)this, this.rows);
            }
            case 6: {
                return ChestMenu.m_39246_((int)pContainerId, (Inventory)pInventory, (Container)this);
            }
        }
        return null;
    }

    public boolean m_6542_(Player pPlayer) {
        return this.f_58857_.m_7702_(this.m_58899_()) == this && pPlayer.m_20182_().m_82509_((Position)Vec3.m_82512_((Vec3i)this.m_58899_()), 8.0);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (!this.m_59634_(pTag)) {
            ContainerHelper.m_18973_((CompoundTag)pTag, this.inventory);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(pTag)) {
            ContainerHelper.m_18980_((CompoundTag)pTag, this.inventory);
        }
    }
}

