/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.searchtree.FullTextSearchTree;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import tanukidecor.TDRegistry;

public final class ClientRecipeCollections {
    public static final SearchRegistry.Key<RecipeCollection> DIY_RECIPE_COLLECTIONS_KEY = new SearchRegistry.Key();
    public static final List<RecipeCollection> DIY_RECIPE_COLLECTIONS = new ArrayList<RecipeCollection>();

    private ClientRecipeCollections() {
    }

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientRecipeCollections::onClientSetup);
        MinecraftForge.EVENT_BUS.addListener(ClientRecipeCollections::onUpdateRecipes);
        MinecraftForge.EVENT_BUS.addListener(ClientRecipeCollections::onUpdateTags);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientRecipeCollections::registerSearchTrees);
    }

    private static void registerSearchTrees() {
        Minecraft.m_91087_().getSearchTreeManager().m_235232_(DIY_RECIPE_COLLECTIONS_KEY, recipes -> new FullTextSearchTree(recipeCollection -> recipeCollection.m_100516_().stream().flatMap(recipe -> recipe.m_8043_(recipeCollection.m_266543_()).m_41651_(null, (TooltipFlag)TooltipFlag.Default.f_256752_).stream()).map(component -> ChatFormatting.m_126649_((String)component.getString()).trim()).filter(s -> !s.isEmpty()), collection -> collection.m_100516_().stream().map(recipe -> ForgeRegistries.ITEMS.getKey((Object)recipe.m_8043_(collection.m_266543_()).m_41720_())), recipes));
    }

    private static void onUpdateRecipes(RecipesUpdatedEvent event) {
        DIY_RECIPE_COLLECTIONS.clear();
        RegistryAccess registryAccess = Minecraft.m_91087_().f_91073_.m_9598_();
        event.getRecipeManager().m_44013_((RecipeType)TDRegistry.RecipeReg.DIY.get()).stream().map(recipe -> new RecipeCollection(registryAccess, (List)ImmutableList.of((Object)recipe))).forEach(DIY_RECIPE_COLLECTIONS::add);
        Minecraft.m_91087_().m_231374_(DIY_RECIPE_COLLECTIONS_KEY, DIY_RECIPE_COLLECTIONS);
    }

    private static void onUpdateTags(TagsUpdatedEvent event) {
        ImmutableList recipes = ImmutableList.copyOf(DIY_RECIPE_COLLECTIONS);
        DIY_RECIPE_COLLECTIONS.clear();
        for (RecipeCollection recipeCollection : recipes) {
            if (recipeCollection.m_100516_().size() != 1 || ((Recipe)recipeCollection.m_100516_().get(0)).m_8043_(event.getRegistryAccess()).m_204117_(TDRegistry.DIY_BLACKLIST_TAG_KEY)) continue;
            DIY_RECIPE_COLLECTIONS.add(recipeCollection);
        }
        Minecraft.m_91087_().m_231374_(DIY_RECIPE_COLLECTIONS_KEY, DIY_RECIPE_COLLECTIONS);
    }
}

