/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client.blockentity.clock;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import tanukidecor.block.clock.IChimeProvider;
import tanukidecor.block.entity.ClockBlockEntity;
import tanukidecor.client.blockentity.clock.ClockBER;
import tanukidecor.client.blockentity.clock.ClockRenderHelper;

public class CuckooClockBER
extends ClockBER {
    public static final ResourceLocation LONG_HAND = new ResourceLocation("tanukidecor", "block/cuckoo_clock/long_hand");
    public static final ResourceLocation SHORT_HAND = new ResourceLocation("tanukidecor", "block/cuckoo_clock/short_hand");
    public static final ResourceLocation CUCKOO = new ResourceLocation("tanukidecor", "block/cuckoo_clock/cuckoo");

    public CuckooClockBER(BlockEntityRendererProvider.Context pContext) {
        super(pContext, SHORT_HAND, LONG_HAND, ROOT_POSITION, ROOT_PIVOT_POINT, HANDS_POSITION, new Vec3(0.5, 0.3125, 0.0));
    }

    @Override
    public void render(ClockBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        super.render(pBlockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay);
    }

    @Override
    public void renderAdditional(ClockRenderHelper renderHelper, ClockBlockEntity blockEntity, MultiBufferSource bufferSource) {
        Block block = blockEntity.m_58900_().m_60734_();
        if (!(block instanceof IChimeProvider)) {
            return;
        }
        IChimeProvider chimeProvider = (IChimeProvider)block;
        int duration = 20;
        long dayTime = (blockEntity.m_58904_().m_46468_() + 0L) % 24000L;
        long adjustedTime = 20L * (dayTime / 20L);
        if (!chimeProvider.isTimeToChime(renderHelper.getBlockState(), adjustedTime)) {
            return;
        }
        BakedModel model = Minecraft.m_91087_().m_91304_().getModel(CUCKOO);
        float cuckooPercent = ((float)(dayTime % 20L) + renderHelper.getPartialTick()) / 20.0f;
        float apex = 0.15f;
        float factor = 2.15f * cuckooPercent - 1.075f;
        float percent = 1.0f - Math.max(0.0f, factor * factor * factor * factor - 0.15f);
        double zPos = -8.0 * (double)percent / 16.0;
        Vec3 position = new Vec3(-0.5, -0.5, zPos);
        this.clockRenderHelper.withModel(model).withPosition(position).withPivotPoint(ROOT_PIVOT_POINT).withRotationZ(0.0f).render(this.blockRenderer);
    }

    public static void addSpecialModels(Set<ResourceLocation> list) {
        list.add(LONG_HAND);
        list.add(SHORT_HAND);
        list.add(CUCKOO);
    }
}

