/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client.blockentity.clock;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import tanukidecor.block.entity.ClockBlockEntity;
import tanukidecor.client.blockentity.clock.ClockBER;
import tanukidecor.client.blockentity.clock.ClockRenderHelper;

public class OwlClockBER
extends ClockBER {
    public static final ResourceLocation LONG_HAND = new ResourceLocation("tanukidecor", "block/owl_clock/long_hand");
    public static final ResourceLocation SHORT_HAND = new ResourceLocation("tanukidecor", "block/owl_clock/short_hand");
    public static final ResourceLocation PENDULUM = new ResourceLocation("tanukidecor", "block/owl_clock/pendulum");
    private static final Vec3 PENDULUM_POSITION = new Vec3(-0.5, -0.5, 0.0);
    private static final Vec3 PENDULUM_PIVOT_POINT = new Vec3(0.5, 0.0, 0.0);

    public OwlClockBER(BlockEntityRendererProvider.Context pContext) {
        super(pContext, SHORT_HAND, LONG_HAND, ROOT_POSITION, ROOT_PIVOT_POINT, HANDS_POSITION, new Vec3(0.5, 0.3125, 0.0));
    }

    @Override
    public void render(ClockBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        super.render(pBlockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay);
    }

    @Override
    public void renderAdditional(ClockRenderHelper renderHelper, ClockBlockEntity blockEntity, MultiBufferSource bufferSource) {
        float pendulumRotation = (float)blockEntity.getBias() * OwlClockBER.getPendulumRotation(1.0f, 0.31415927f, blockEntity.m_58904_().m_46467_(), renderHelper.getPartialTick());
        BakedModel pendulum = Minecraft.m_91087_().m_91304_().getModel(PENDULUM);
        renderHelper.withModel(pendulum).withPosition(PENDULUM_POSITION).withPivotPoint(PENDULUM_PIVOT_POINT).withRotationZ(pendulumRotation).render(this.blockRenderer);
    }

    public static void addSpecialModels(Set<ResourceLocation> list) {
        list.add(LONG_HAND);
        list.add(SHORT_HAND);
        list.add(PENDULUM);
    }
}

