/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model;

import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidLegAnimation;
import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;

public interface EasyNPCModel<E extends Entity> {
    public static final CustomPosition EMPTY_POSITION = new CustomPosition(0.0f, 0.0f, 0.0f);
    public static final CustomRotation EMPTY_ROTATION = new CustomRotation(0.0f, 0.0f, 0.0f);

    private static boolean equalPositionAndRotation(ModelPart modelPart, CustomPosition position, CustomRotation rotation) {
        return EasyNPCModel.equalPosition(modelPart, position) && EasyNPCModel.equalRotation(modelPart, rotation);
    }

    private static boolean equalPosition(ModelPart modelPart, CustomPosition position) {
        return modelPart != null && (double)Math.abs(modelPart.f_104200_ - position.x()) < 0.01 && (double)Math.abs(modelPart.f_104201_ - position.y()) < 0.01 && (double)Math.abs(modelPart.f_104202_ - position.z()) < 0.01;
    }

    private static boolean equalRotation(ModelPart modelPart, CustomRotation rotation) {
        return modelPart != null && (double)Math.abs(modelPart.f_104203_ - rotation.x()) < 0.01 && (double)Math.abs(modelPart.f_104204_ - rotation.y()) < 0.01 && (double)Math.abs(modelPart.f_104205_ - rotation.z()) < 0.01;
    }

    default public void resetModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        if (this.getDefaultModelPartVisibility(modelPartType)) {
            CustomPosition defaultPosition = this.getDefaultModelPartPosition(modelPartType);
            modelPart.m_104227_(defaultPosition.x(), defaultPosition.y(), defaultPosition.z());
            CustomRotation defaultRotation = this.getDefaultModelPartRotation(modelPartType);
            modelPart.m_171327_(defaultRotation.x(), defaultRotation.y(), defaultRotation.z());
            modelPart.f_104207_ = true;
        } else {
            modelPart.f_104207_ = false;
        }
    }

    default public boolean isHumanoidModel() {
        return true;
    }

    default public boolean hasDefaultModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        CustomPosition defaultPosition = this.getDefaultModelPartPosition(modelPartType);
        CustomRotation defaultRotation = this.getDefaultModelPartRotation(modelPartType);
        return EasyNPCModel.equalPositionAndRotation(modelPart, defaultPosition, defaultRotation);
    }

    default public ModelPart defineModelPart(ModelPartType modelPartType, ModelPart parentModel, String name) {
        ModelPart modelPart = parentModel.m_171324_(name);
        return this.defineModelPart(modelPartType, modelPart);
    }

    default public ModelPart defineModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        this.setDefaultModelPartPosition(modelPartType, new CustomPosition(modelPart.f_104200_, modelPart.f_104201_, modelPart.f_104202_));
        this.setDefaultModelPartRotation(modelPartType, new CustomRotation(modelPart.f_104203_, modelPart.f_104204_, modelPart.f_104205_));
        this.setDefaultModelPartVisibility(modelPartType, modelPart.f_104207_);
        this.setDefaultModelPart(modelPartType, modelPart);
        return modelPart;
    }

    public void resetModelParts();

    public Map<ModelPartType, CustomPosition> getModelPartPositionMap();

    public Map<ModelPartType, CustomRotation> getModelPartRotationMap();

    public Map<ModelPartType, Boolean> getModelPartVisibilityMap();

    public Map<ModelPartType, ModelPart> getModelPartMap();

    default public void setDefaultModelPartPosition(ModelPartType modelPartType, CustomPosition customPosition) {
        this.getModelPartPositionMap().put(modelPartType, customPosition);
    }

    default public void setDefaultModelPartRotation(ModelPartType modelPartType, CustomRotation rotation) {
        this.getModelPartRotationMap().put(modelPartType, rotation);
    }

    default public void setDefaultModelPartVisibility(ModelPartType modelPartType, boolean isVisible) {
        this.getModelPartVisibilityMap().put(modelPartType, isVisible);
    }

    default public void setDefaultModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        this.getModelPartMap().put(modelPartType, modelPart);
    }

    default public CustomPosition getDefaultModelPartPosition(ModelPartType modelPartType) {
        return this.getModelPartPositionMap().getOrDefault((Object)modelPartType, EMPTY_POSITION);
    }

    default public CustomRotation getDefaultModelPartRotation(ModelPartType modelPartType) {
        return this.getModelPartRotationMap().getOrDefault((Object)modelPartType, EMPTY_ROTATION);
    }

    default public boolean getDefaultModelPartVisibility(ModelPartType modelPartType) {
        return this.getModelPartVisibilityMap().getOrDefault((Object)modelPartType, true);
    }

    default public ModelPart getDefaultModelPart(ModelPartType modelPartType) {
        return this.getModelPartMap().getOrDefault((Object)modelPartType, null);
    }

    default public void setupCustomModelPose(E entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    default public void animateCustomModelPose(E entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    default public void adjustDefaultModelParts(E entity, EasyNPC<?> easyNPC) {
    }

    default public boolean setupDefaultModelPose(E entity, Pose pose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean animateDefaultModelPose(E entity, Pose pose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean setupStandingModelPose(E entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean setupCrouchingModelPose(E entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean setupFallbackModelPose(E entity, Pose pose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean additionalModelAnimation(E entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean animateModelHead(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean animateModelBody(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart bodyPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return false;
    }

    default public boolean animateModelArmPose(E entity, ModelArmPose modelArmPose, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return false;
    }

    default public boolean animateModelArms(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightArmPart, ModelPart leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        boolean result = false;
        if (rightArmPart != null) {
            result = this.animateModelRightArm(entity, attackData, modelData, rightArmPart, ageInTicks, limbSwing, limbSwingAmount);
        }
        if (leftArmPart != null) {
            result = this.animateModelLeftArm(entity, attackData, modelData, leftArmPart, ageInTicks, limbSwing, limbSwingAmount);
        }
        return result;
    }

    default public boolean animateModelRightArm(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return false;
    }

    default public boolean animateModelLeftArm(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return false;
    }

    default public boolean animateModelLegs(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null || leftLegPart == null) {
            return false;
        }
        return HumanoidLegAnimation.animateHumanoidModelLegs(rightLegPart, leftLegPart, ageInTicks, limbSwing, limbSwingAmount);
    }

    default public boolean animateModelFrontLegs(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return false;
    }

    default public boolean animateModelHindLegs(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return false;
    }

    default public void animateAttackModelPose(E entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    default public boolean handleDefaultModelPose(E entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Pose pose = modelData.getDefaultPose();
        boolean hasAdjustedDefaultModelPose = this.setupDefaultModelPose(entity, pose, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        hasAdjustedDefaultModelPose = switch (pose) {
            case Pose.STANDING -> {
                if (hasAdjustedDefaultModelPose || this.setupStandingModelPose(entity, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch)) {
                    yield true;
                }
                yield false;
            }
            case Pose.CROUCHING -> {
                if (hasAdjustedDefaultModelPose || this.setupCrouchingModelPose(entity, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch)) {
                    yield true;
                }
                yield false;
            }
            default -> hasAdjustedDefaultModelPose || this.setupFallbackModelPose(entity, pose, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        };
        hasAdjustedDefaultModelPose = hasAdjustedDefaultModelPose || this.animateDefaultModelPose(entity, pose, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        return hasAdjustedDefaultModelPose;
    }

    default public boolean handleSmartAnimations(E entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPart body;
        boolean hasDefaultBody;
        boolean hasDefaultHead;
        boolean isHumanoidModel = this.isHumanoidModel();
        boolean hasAnimatedModelBody = false;
        boolean hasAnimatedModelHead = false;
        boolean hasAnimatedModelArms = false;
        boolean hasAnimatedModelArmPose = false;
        boolean hasAnimatedModelLegs = false;
        boolean hasAnimatedModelFrontLegs = false;
        boolean hasAnimatedModelHindLegs = false;
        this.animateAttackModelPose(entity, attackData, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ModelPart head = this.getDefaultModelPart(ModelPartType.HEAD);
        boolean bl = hasDefaultHead = head != null && this.hasDefaultModelPart(ModelPartType.HEAD, head);
        if (hasDefaultHead) {
            hasAnimatedModelHead = this.animateModelHead(entity, attackData, modelData, head, ageInTicks, netHeadYaw, headPitch);
        }
        boolean bl2 = hasDefaultBody = (body = this.getDefaultModelPart(ModelPartType.BODY)) != null && this.hasDefaultModelPart(ModelPartType.BODY, body);
        if (hasDefaultBody) {
            hasAnimatedModelBody = this.animateModelBody(entity, attackData, modelData, body, ageInTicks, limbSwing, limbSwingAmount);
        }
        if (isHumanoidModel) {
            ModelArmPose modelArmPose = modelData.getModelArmPose();
            if (modelArmPose == ModelArmPose.DEFAULT || modelArmPose == ModelArmPose.NEUTRAL) {
                ModelPart rightArm = this.getDefaultModelPart(ModelPartType.RIGHT_ARM);
                boolean hasDefaultRightArm = rightArm != null && this.hasDefaultModelPart(ModelPartType.RIGHT_ARM, rightArm);
                ModelPart leftArm = this.getDefaultModelPart(ModelPartType.LEFT_ARM);
                boolean hasDefaultLeftArm = leftArm != null && this.hasDefaultModelPart(ModelPartType.LEFT_ARM, leftArm);
                hasAnimatedModelArms = this.animateModelArms(entity, attackData, modelData, (ModelPart)(hasDefaultRightArm ? rightArm : null), (ModelPart)(hasDefaultLeftArm ? leftArm : null), ageInTicks, limbSwing, limbSwingAmount);
            } else {
                hasAnimatedModelArmPose = this.animateModelArmPose(entity, modelArmPose, attackData, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
            ModelPart rightLeg = this.getDefaultModelPart(ModelPartType.RIGHT_LEG);
            ModelPart leftLeg = this.getDefaultModelPart(ModelPartType.LEFT_LEG);
            hasAnimatedModelLegs = this.animateModelLegs(entity, attackData, modelData, rightLeg != null && this.hasDefaultModelPart(ModelPartType.RIGHT_LEG, rightLeg) ? rightLeg : null, leftLeg != null && this.hasDefaultModelPart(ModelPartType.LEFT_LEG, leftLeg) ? leftLeg : null, ageInTicks, limbSwing, limbSwingAmount);
        } else {
            ModelPart rightFrontLeg = this.getDefaultModelPart(ModelPartType.RIGHT_FRONT_LEG);
            ModelPart leftFrontLeg = this.getDefaultModelPart(ModelPartType.LEFT_FRONT_LEG);
            hasAnimatedModelFrontLegs = this.animateModelFrontLegs(entity, attackData, modelData, rightFrontLeg != null && this.hasDefaultModelPart(ModelPartType.RIGHT_FRONT_LEG, rightFrontLeg) ? rightFrontLeg : null, leftFrontLeg != null && this.hasDefaultModelPart(ModelPartType.LEFT_FRONT_LEG, leftFrontLeg) ? leftFrontLeg : null, ageInTicks, limbSwing, limbSwingAmount);
            ModelPart rightHindLeg = this.getDefaultModelPart(ModelPartType.RIGHT_HIND_LEG);
            ModelPart leftHindLeg = this.getDefaultModelPart(ModelPartType.LEFT_HIND_LEG);
            hasAnimatedModelHindLegs = this.animateModelHindLegs(entity, attackData, modelData, rightHindLeg != null && this.hasDefaultModelPart(ModelPartType.RIGHT_HIND_LEG, rightHindLeg) ? rightHindLeg : null, leftHindLeg != null && this.hasDefaultModelPart(ModelPartType.LEFT_HIND_LEG, leftHindLeg) ? leftHindLeg : null, ageInTicks, limbSwing, limbSwingAmount);
        }
        return hasAnimatedModelHead || hasAnimatedModelBody || hasAnimatedModelArms || hasAnimatedModelArmPose || hasAnimatedModelLegs || hasAnimatedModelFrontLegs || hasAnimatedModelHindLegs || !hasDefaultHead;
    }

    default public boolean setupAnimation(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entity instanceof EasyNPC)) {
            return false;
        }
        EasyNPC easyNPC = (EasyNPC)entity;
        this.resetModelParts();
        ModelData modelData = easyNPC.getEasyNPCModelData();
        ModelPose modelPose = modelData.getModelPose();
        AttackData attackData = easyNPC.getEasyNPCAttackData();
        boolean isCustomModelPose = modelPose == ModelPose.CUSTOM;
        boolean isDefaultModelPose = modelPose == ModelPose.DEFAULT;
        boolean hasAdjustedDefaultModelPose = false;
        boolean hasSmartAnimations = modelData.useSmartAnimations();
        if (isCustomModelPose) {
            this.setupCustomModelPose(entity, modelPose, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.animateCustomModelPose(entity, modelPose, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        } else if (isDefaultModelPose) {
            this.resetModelParts();
            hasAdjustedDefaultModelPose = this.handleDefaultModelPose(entity, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        if (modelData.useSmartAnimations() || isCustomModelPose || hasAdjustedDefaultModelPose) {
            hasSmartAnimations = this.handleSmartAnimations(entity, attackData, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        boolean hasAdditionalModelAnimation = this.additionalModelAnimation(entity, attackData, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.adjustDefaultModelParts(entity, easyNPC);
        return isCustomModelPose || isDefaultModelPose && hasAdjustedDefaultModelPose || hasSmartAnimations || hasAdditionalModelAnimation;
    }
}

