/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.attribute;

import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.attribute.AttributeConfigurationScreen;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Inventory;

public class BaseAttributeConfigurationScreen<T extends ConfigurationMenu>
extends AttributeConfigurationScreen<T> {
    RangeSliderButton armorSlider;
    RangeSliderButton armorToughnessSlider;
    RangeSliderButton attackDamageSlider;
    RangeSliderButton attackKnockbackSlider;
    RangeSliderButton attackSpeedSlider;
    RangeSliderButton flyingSpeedSlider;
    RangeSliderButton followRangeSlider;
    RangeSliderButton knockbackResistanceSlider;
    RangeSliderButton maxHealthSlider;
    RangeSliderButton movementSpeedSlider;

    public BaseAttributeConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected RangeSliderButton createAttributeSlider(int left, int top, int width, int height, Attribute attribute, double value, double defaultMinValue, double defaultMaxValue, double defaultValue, double stepSize, SliderButton.OnChange onChange) {
        double d;
        double minValue;
        if (attribute instanceof RangedAttribute) {
            RangedAttribute rangedAttribute = (RangedAttribute)attribute;
            v0 = rangedAttribute.m_147361_();
        } else {
            v0 = minValue = defaultMinValue;
        }
        if (attribute instanceof RangedAttribute) {
            RangedAttribute rangedAttribute = (RangedAttribute)attribute;
            d = rangedAttribute.m_147362_();
        } else {
            d = defaultMaxValue;
        }
        double maxValue = d;
        return (RangeSliderButton)this.m_142416_((GuiEventListener)new RangeSliderButton(left, top, width, height, attribute.m_22087_(), value, minValue, maxValue, defaultValue, stepSize, onChange));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.baseAttributeButton.f_93623_ = false;
        int sliderXPos = this.buttonLeftPos + 130;
        int sliderYPos = this.buttonTopPos + 22;
        int sliderWidth = 170;
        int sliderHeight = 14;
        int sliderYSpace = 20;
        LivingEntity livingEntity = this.getEasyNPC().getLivingEntity();
        this.maxHealthSlider = this.createAttributeSlider(sliderXPos, sliderYPos, sliderWidth, sliderHeight, Attributes.f_22276_, livingEntity.m_21172_(Attributes.f_22276_), 1.0, 1024.0, 20.0, 1.0, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), Attributes.f_22276_, slider.getTargetDoubleValue()));
        this.followRangeSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, Attributes.f_22277_, this.getBaseAttributes().getFollowRange(), 0.0, 2048.0, 32.0, 1.0, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), Attributes.f_22277_, slider.getTargetDoubleValue()));
        this.knockbackResistanceSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, Attributes.f_22278_, this.getBaseAttributes().getKnockbackResistance(), 0.0, 1.0, 0.0, 0.1, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), Attributes.f_22278_, slider.getTargetDoubleValue()));
        if (livingEntity.m_21051_(Attributes.f_22279_) != null) {
            this.movementSpeedSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, Attributes.f_22279_, livingEntity.m_21172_(Attributes.f_22279_), 0.0, 2.0, 0.6, 0.1, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), Attributes.f_22279_, slider.getTargetDoubleValue()));
        }
        if (livingEntity.m_21051_(Attributes.f_22280_) != null) {
            this.flyingSpeedSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, Attributes.f_22280_, livingEntity.m_21172_(Attributes.f_22280_), 0.0, 2.0, 0.4, 0.1, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), Attributes.f_22280_, slider.getTargetDoubleValue()));
        }
        this.attackDamageSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, Attributes.f_22281_, this.getBaseAttributes().getAttackDamage(), 0.0, 2048.0, 2.0, 1.0, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), Attributes.f_22281_, slider.getTargetDoubleValue()));
        this.attackKnockbackSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, Attributes.f_22282_, this.getBaseAttributes().getAttackKnockback(), 0.0, 5.0, 0.0, 0.1, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), Attributes.f_22282_, slider.getTargetDoubleValue()));
        if (livingEntity.m_21051_(Attributes.f_22283_) != null) {
            this.attackSpeedSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, Attributes.f_22283_, livingEntity.m_21172_(Attributes.f_22283_), 0.0, 1024.0, 4.0, 0.5, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), Attributes.f_22283_, slider.getTargetDoubleValue()));
        }
        this.armorSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, Attributes.f_22284_, livingEntity.m_21172_(Attributes.f_22284_), 0.0, 30.0, 0.0, 1.0, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), Attributes.f_22284_, slider.getTargetDoubleValue()));
        this.armorToughnessSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, Attributes.f_22285_, livingEntity.m_21172_(Attributes.f_22285_), 0.0, 20.0, 0.0, 0.5, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), Attributes.f_22285_, slider.getTargetDoubleValue()));
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        int sliderXOffset = -135;
        int sliderYOffset = 3;
        if (this.maxHealthSlider != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "max_health", this.maxHealthSlider.m_252754_() + sliderXOffset, this.maxHealthSlider.m_252907_() + sliderYOffset);
        }
        if (this.followRangeSlider != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "follow_range", this.followRangeSlider.m_252754_() + sliderXOffset, this.followRangeSlider.m_252907_() + sliderYOffset);
        }
        if (this.knockbackResistanceSlider != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "knockback_resistance", this.knockbackResistanceSlider.m_252754_() + sliderXOffset, this.knockbackResistanceSlider.m_252907_() + sliderYOffset);
        }
        if (this.movementSpeedSlider != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "movement_speed", this.movementSpeedSlider.m_252754_() + sliderXOffset, this.movementSpeedSlider.m_252907_() + sliderYOffset);
        }
        if (this.flyingSpeedSlider != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "flying_speed", this.flyingSpeedSlider.m_252754_() + sliderXOffset, this.flyingSpeedSlider.m_252907_() + sliderYOffset);
        }
        if (this.attackDamageSlider != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "attack_damage", this.attackDamageSlider.m_252754_() + sliderXOffset, this.attackDamageSlider.m_252907_() + sliderYOffset);
        }
        if (this.attackKnockbackSlider != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "attack_knockback", this.attackKnockbackSlider.m_252754_() + sliderXOffset, this.attackKnockbackSlider.m_252907_() + sliderYOffset);
        }
        if (this.attackSpeedSlider != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "attack_speed", this.attackSpeedSlider.m_252754_() + sliderXOffset, this.attackSpeedSlider.m_252907_() + sliderYOffset);
        }
        if (this.armorSlider != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "armor", this.armorSlider.m_252754_() + sliderXOffset, this.armorSlider.m_252907_() + sliderYOffset);
        }
        if (this.armorToughnessSlider != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "armor_toughness", this.armorToughnessSlider.m_252754_() + sliderXOffset, this.armorToughnessSlider.m_252907_() + sliderYOffset);
        }
    }
}

