/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor.dialog;

import de.markusbordihn.easynpc.client.screen.EditorScreen;
import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.client.screen.components.EditButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;

public class DialogButtonEditorScreen<T extends EditorMenu>
extends EditorScreen<T> {
    protected Button homeButton;
    protected Button dialogButton;
    protected Button dialogButtonButton;
    protected Button saveButton;
    protected Button cancelButton;
    protected Button deleteButton;
    protected TextField buttonNameBox;
    protected Button buttonNameToLabelButton;
    protected TextField buttonLabelBox;
    protected Checkbox buttonLabelCheckbox;
    private String buttonLabelValue = "";
    private String buttonNameValue = "";

    public DialogButtonEditorScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void deleteDialogButton() {
        if (this.f_96541_ == null) {
            return;
        }
        this.f_96541_.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.getDialogUUID() != null) {
                NetworkMessageHandlerManager.getServerHandler().removeDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID());
                NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID());
            } else {
                this.f_96541_.m_91152_((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedText("removeDialogButton.deleteQuestion"), (Component)TextComponent.getTranslatedText("removeDialogButton.deleteWarning", this.getDialogButtonData().name()), (Component)TextComponent.getTranslatedText("removeDialogButton.deleteButton"), CommonComponents.f_130656_));
    }

    protected void renderEditLabels(GuiGraphics guiGraphics) {
        if (this.buttonNameBox != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "button.name", this.leftPos + 12, this.buttonNameBox.m_252907_() + 4);
        }
        if (this.buttonLabelBox != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "label_id", this.leftPos + 12, this.buttonLabelBox.m_252907_() + 4);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.homeButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.leftPos + 7, this.topPos + 7, 10, 18, "<", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG)));
        this.dialogButton = (Button)this.m_142416_((GuiEventListener)new DialogButton(this.homeButton.m_252754_() + this.homeButton.m_5711_(), this.topPos + 7, 140, this.getDialogData().getName(21), onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID())));
        this.dialogButtonButton = (Button)this.m_142416_((GuiEventListener)new DialogButtonButton(this.dialogButton.m_252754_() + this.dialogButton.m_5711_(), this.topPos + 7, 140, this.getDialogButtonData().getButtonName(21).getString(), onPress -> {}));
        this.dialogButtonButton.f_93623_ = false;
        this.buttonNameValue = this.getDialogButtonData().name();
        this.buttonNameBox = new TextField(this.f_96547_, this.leftPos + 100, this.topPos + 30, 150);
        this.buttonNameBox.m_94199_(64);
        this.buttonNameBox.m_94144_(this.buttonNameValue);
        this.m_142416_((GuiEventListener)this.buttonNameBox);
        this.buttonNameToLabelButton = (Button)this.m_142416_((GuiEventListener)new SpriteButton(this.buttonNameBox.m_252754_() + this.buttonNameBox.m_5711_() + 1, this.buttonNameBox.m_252907_() - 1, 18, 18, 4, 4, 80, 80, 12, 12, onPress -> {
            if (this.buttonNameBox != null && this.buttonLabelBox != null) {
                String buttonName = this.buttonNameBox.m_94155_();
                this.buttonLabelBox.m_94144_(DialogUtils.generateButtonLabel(buttonName));
            }
        }));
        this.buttonLabelValue = this.getDialogButtonData().label();
        this.buttonLabelBox = new TextField(this.f_96547_, this.leftPos + 100, this.topPos + 50, 100);
        this.buttonLabelBox.m_94199_(32);
        this.buttonLabelBox.m_94144_(this.buttonLabelValue);
        this.buttonLabelBox.m_94186_(false);
        this.m_142416_((GuiEventListener)this.buttonLabelBox);
        this.buttonLabelCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.leftPos + 204, this.buttonLabelBox.m_252907_() + 1, "locked", true, onPress -> this.buttonLabelBox.m_94186_(!this.buttonLabelCheckbox.selected())));
        this.m_142416_((GuiEventListener)this.getActionDataButton(this.leftPos + 10, this.topPos + 70));
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.leftPos + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveDialogButton();
            NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID());
        }));
        this.deleteButton = (Button)this.m_142416_((GuiEventListener)new DeleteButton(this.saveButton.m_252754_() + this.saveButton.m_5711_() + 10, this.bottomPos - 35, 85, onPress -> this.deleteDialogButton()));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new CancelButton(this.deleteButton.m_252754_() + this.deleteButton.m_5711_() + 10, this.bottomPos - 35, 85, "cancel", onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID())));
    }

    private void saveDialogButton() {
        DialogButtonEntry dialogButtonEntry = this.getDialogButtonData();
        if (dialogButtonEntry == null) {
            return;
        }
        DialogButtonEntry newDialogButtonEntry = dialogButtonEntry.withName(this.buttonNameBox.m_94155_()).withLabel(this.buttonLabelBox.m_94155_());
        NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), newDialogButtonEntry);
    }

    @Override
    public void updateTick() {
        super.updateTick();
        if (this.saveButton != null) {
            boolean bl = this.saveButton.f_93623_ = !this.buttonNameBox.m_94155_().equals(this.buttonNameValue) || !this.buttonLabelBox.m_94155_().equals(this.buttonLabelValue);
        }
        if (this.buttonLabelCheckbox != null && this.buttonNameToLabelButton != null) {
            this.buttonNameToLabelButton.f_93623_ = !this.buttonLabelCheckbox.selected();
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, x, y, partialTicks);
        this.renderEditLabels(guiGraphics);
        if (this.buttonNameToLabelButton != null && this.buttonNameToLabelButton.m_5953_((double)x, (double)y)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)TextComponent.getTranslatedConfigText("name_to_label.tooltip"), x, y);
        }
    }

    protected Button getActionDataButton(int left, int top) {
        int buttonWidth = 300;
        ActionDataSet actionDataSet = this.getDialogButtonData().actionDataSet();
        if (actionDataSet == null || actionDataSet.isEmpty()) {
            MutableComponent buttonLabel = TextComponent.getTextComponent("add_action", "button");
            return new AddButton(left, top, buttonWidth, (Component)buttonLabel, onPress -> NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), EditorType.DIALOG_BUTTON, this.getDialogUUID(), this.getDialogButtonUUID(), new ActionDataEntry())).setRenderCenter(false);
        }
        MutableComponent buttonLabel = TextComponent.getTextComponent("edit_action", "button");
        return new EditButton(left, top, buttonWidth, (Component)buttonLabel, onPress -> NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), EditorType.DIALOG_BUTTON, this.getDialogUUID(), this.getDialogButtonUUID())).setRenderCenter(false);
    }
}

