/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu.editor;

import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.editor.EditorMenu;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class EditorMenuHandler {
    private EditorMenuHandler() {
    }

    public static MenuProvider getMenuProvider(final EditorType editorType, final EasyNPC<?> easyNPC, final MenuType<? extends EditorMenu> menuType, final ScreenData screenData) {
        final Component displayName = editorType.getEditorTitle(easyNPC);
        return new MenuProvider(){

            public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                return new EditorMenu(menuType, containerId, playerInventory, screenData.encode());
            }

            public Component m_5446_() {
                return displayName;
            }

            public String toString() {
                return "EditorMenuHandler{editorType=" + editorType + ", easyNPC=" + easyNPC + ", screenData=" + screenData + "}";
            }
        };
    }

    public static ScreenData getScreenData(EditorType editorType, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, int pageIndex, CompoundTag additionalSyncData) {
        UUID npcUUID = easyNPC.m_20148_();
        switch (editorType) {
            case DIALOG: 
            case DIALOG_BUTTON: 
            case DIALOG_TEXT: {
                AdditionalScreenData.addDialogDataSet(additionalSyncData, easyNPC);
                break;
            }
            case ACTION_DATA: 
            case ACTION_DATA_ENTRY: {
                AdditionalScreenData.addActionEventSet(additionalSyncData, easyNPC);
                AdditionalScreenData.addDialogDataSet(additionalSyncData, easyNPC);
                break;
            }
        }
        return new ScreenData(npcUUID, dialogId, dialogButtonId, actionDataEntryId, pageIndex, additionalSyncData);
    }
}

