/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface NetworkHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");
    public static final String LOG_PREFIX = "[NetworkHandler]";
    public static final int PROTOCOL_VERSION = 23;

    public <M extends NetworkMessageRecord> void registerClientNetworkMessageHandler(ResourceLocation var1, Class<M> var2, Function<FriendlyByteBuf, M> var3);

    public <M extends NetworkMessageRecord> void registerServerNetworkMessageHandler(ResourceLocation var1, Class<M> var2, Function<FriendlyByteBuf, M> var3);

    public <M extends NetworkMessageRecord> void sendToServer(M var1);

    public <M extends NetworkMessageRecord> void sendToPlayer(M var1, ServerPlayer var2);

    public <M extends NetworkMessageRecord> void addClientMessage(ResourceLocation var1, Class<M> var2);

    public <M extends NetworkMessageRecord> void addServerMessage(ResourceLocation var1, Class<M> var2);

    public Map<ResourceLocation, Class<? extends NetworkMessageRecord>> getClientMessages();

    public Map<ResourceLocation, Class<? extends NetworkMessageRecord>> getServerMessages();

    public <M extends NetworkMessageRecord> void addRegisteredClientMessage(ResourceLocation var1, Class<M> var2);

    public <M extends NetworkMessageRecord> void addRegisteredServerMessage(ResourceLocation var1, Class<M> var2);

    public Map<ResourceLocation, Class<? extends NetworkMessageRecord>> getRegisteredClientMessages();

    public Map<ResourceLocation, Class<? extends NetworkMessageRecord>> getRegisteredServerMessages();

    default public boolean sendMessageToPlayer(NetworkMessageRecord networkMessageRecord, ServerPlayer serverPlayer) {
        if (!this.hasClientMessage(networkMessageRecord.id())) {
            log.error("{} Message {} is not registered as client message", (Object)LOG_PREFIX, (Object)networkMessageRecord.id());
            return false;
        }
        try {
            this.sendToPlayer(networkMessageRecord, serverPlayer);
        }
        catch (Exception e) {
            log.error("{} Failed to send message {} to player {}", (Object)LOG_PREFIX, (Object)networkMessageRecord.id(), (Object)serverPlayer.m_7755_().getString(), (Object)e);
            return false;
        }
        return true;
    }

    default public boolean sendMessageToServer(NetworkMessageRecord networkMessageRecord) {
        if (!this.hasServerMessage(networkMessageRecord.id())) {
            log.error("{} Message {} is not registered as server message", (Object)LOG_PREFIX, (Object)networkMessageRecord.id());
            return false;
        }
        if (Minecraft.m_91087_().m_91403_() == null) {
            log.error("{} Failed to send message {} to server: No connection available", (Object)LOG_PREFIX, (Object)networkMessageRecord.id());
            return false;
        }
        try {
            this.sendToServer(networkMessageRecord);
        }
        catch (Exception e) {
            log.error("{} Failed to send message {} to server", (Object)LOG_PREFIX, (Object)networkMessageRecord.id(), (Object)e);
            return false;
        }
        return true;
    }

    default public boolean hasClientMessage(ResourceLocation messageID) {
        return this.getClientMessages().containsKey(messageID);
    }

    default public boolean hasServerMessage(ResourceLocation messageID) {
        return this.getServerMessages().containsKey(messageID);
    }

    default public Class<? extends NetworkMessageRecord> getRegisteredClientMessage(ResourceLocation messageID) {
        return this.getRegisteredClientMessages().get(messageID);
    }

    default public Class<? extends NetworkMessageRecord> getRegisteredServerMessage(ResourceLocation messageID) {
        return this.getRegisteredServerMessages().get(messageID);
    }

    default public ResourceLocation getRegisteredClientMessageId(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredClientMessages().entrySet().stream().filter(entry -> ((Class)entry.getValue()).equals(networkMessage)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    default public ResourceLocation getRegisteredServerMessageId(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredServerMessages().entrySet().stream().filter(entry -> ((Class)entry.getValue()).equals(networkMessage)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    default public boolean hasRegisteredClientMessage(ResourceLocation messageID) {
        return this.getRegisteredClientMessages().containsKey(messageID);
    }

    default public boolean hasRegisteredClientMessage(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredClientMessages().containsValue(networkMessage);
    }

    default public boolean hasRegisteredServerMessage(ResourceLocation messageID) {
        return this.getRegisteredServerMessages().containsKey(messageID);
    }

    default public boolean hasRegisteredServerMessage(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredServerMessages().containsValue(networkMessage);
    }

    default public <M extends NetworkMessageRecord> void registerServerNetworkMessage(ResourceLocation messageID, Class<M> networkMessage, Function<FriendlyByteBuf, M> creator) {
        if (NetworkHandlerManager.isServerNetworkHandler()) {
            if (this.hasRegisteredServerMessage(messageID)) {
                log.error("{} Server network message id {} already registered with {}", (Object)LOG_PREFIX, (Object)messageID, this.getRegisteredServerMessage(messageID));
                return;
            }
            if (this.hasRegisteredServerMessage(networkMessage)) {
                log.error("{} Server network message {} already registered with id {}", (Object)LOG_PREFIX, networkMessage, (Object)this.getRegisteredServerMessageId(networkMessage));
                return;
            }
            try {
                this.registerServerNetworkMessageHandler(messageID, networkMessage, creator);
                this.addRegisteredServerMessage(messageID, networkMessage);
            }
            catch (Exception e) {
                log.error("{} Failed to register server network message id {} with {}", (Object)LOG_PREFIX, (Object)messageID, networkMessage, (Object)e);
                return;
            }
        }
        this.addServerMessage(messageID, networkMessage);
    }

    default public <M extends NetworkMessageRecord> void registerClientNetworkMessage(ResourceLocation messageID, Class<M> networkMessage, Function<FriendlyByteBuf, M> creator) {
        if (NetworkHandlerManager.isClientNetworkHandler()) {
            if (this.hasRegisteredClientMessage(messageID)) {
                log.error("{} Client network message id {} already registered with {}", (Object)LOG_PREFIX, (Object)messageID, this.getRegisteredClientMessage(messageID));
                return;
            }
            if (this.hasRegisteredClientMessage(networkMessage)) {
                log.error("{} Client network message {} already registered with id {}", (Object)LOG_PREFIX, networkMessage, (Object)this.getRegisteredClientMessageId(networkMessage));
                return;
            }
            try {
                this.registerClientNetworkMessageHandler(messageID, networkMessage, creator);
                this.addRegisteredClientMessage(messageID, networkMessage);
            }
            catch (Exception e) {
                log.error("{} Failed to register client network message id {} with {}", (Object)LOG_PREFIX, (Object)messageID, networkMessage, (Object)e);
                return;
            }
        }
        this.addClientMessage(messageID, networkMessage);
    }

    default public void logRegisterClientNetworkMessageHandler(ResourceLocation messageID, Class<?> networkMessage) {
        log.info("{} Registering client network message {} with {}", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), (Object)messageID);
    }

    default public void logRegisterClientNetworkMessageHandler(ResourceLocation messageID, Class<?> networkMessage, int registrationID) {
        log.info("{} Registering client network message {} with {} ({})", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), (Object)messageID, (Object)registrationID);
    }

    default public void logRegisterServerNetworkMessageHandler(ResourceLocation messageID, Class<?> networkMessage) {
        log.info("{} Registering server network message {} with {}", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), (Object)messageID);
    }

    default public void logRegisterServerNetworkMessageHandler(ResourceLocation messageID, Class<?> networkMessage, int registrationID) {
        log.info("{} Registering server network message {} with {} ({})", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), (Object)messageID, (Object)registrationID);
    }
}

