/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.client;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record ExportClientPresetMessage(UUID uuid, String name, SkinModel skinModel, String fileName, CompoundTag data) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "preset_export_client");

    public static ExportClientPresetMessage create(FriendlyByteBuf buffer) {
        return new ExportClientPresetMessage(buffer.m_130259_(), buffer.m_130277_(), (SkinModel)buffer.m_130066_(SkinModel.class), buffer.m_130277_(), buffer.m_130260_());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130070_(this.name);
        buffer.m_130068_((Enum)this.skinModel);
        buffer.m_130070_(this.fileName);
        buffer.m_130079_(this.data);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleClient() {
        if (this.uuid == null || this.uuid.toString().isEmpty()) {
            log.error("Invalid UUID {} for {}", (Object)this.uuid, (Object)this);
            return;
        }
        if (this.name == null || this.name.isEmpty()) {
            log.error("Invalid name {} for {}", (Object)this.name, (Object)this);
            return;
        }
        if (this.skinModel == null) {
            log.error("Invalid skin model for {}", (Object)this);
            return;
        }
        if (this.data == null) {
            log.error("Invalid data for {}", (Object)this);
            return;
        }
        if (this.fileName == null || this.fileName.isEmpty()) {
            log.warn("Export preset file name is empty for {}", (Object)this.uuid);
            return;
        }
        File presetFile = CustomPresetDataFiles.getPresetFile(this.skinModel, this.fileName);
        if (presetFile == null) {
            log.error("Failed to get preset file for {}", (Object)this);
            return;
        }
        log.info("Exporting EasyNPC {} with UUID {} and skin {} to {}", (Object)this.name, (Object)this.uuid, (Object)this.skinModel, (Object)presetFile);
        try {
            NbtIo.m_128944_((CompoundTag)this.data, (File)presetFile);
        }
        catch (IOException exception) {
            log.error("Failed to export EasyNPC {} with UUID {} and skin {} to {}:", (Object)this.name, (Object)this.uuid, (Object)this.skinModel, (Object)presetFile, (Object)exception);
        }
    }
}

