/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.display.DisplayAttributeEntry;
import de.markusbordihn.easynpc.data.display.DisplayAttributeSet;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType displayAttributeType, Boolean booleanValue, Integer integerValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "change_display_attribute");

    public ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType displayAttributeType, Boolean value) {
        this(uuid, displayAttributeType, value, 0);
    }

    public ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType displayAttributeType, Integer value) {
        this(uuid, displayAttributeType, false, value);
    }

    public static ChangeDisplayAttributeMessage create(FriendlyByteBuf buffer) {
        return new ChangeDisplayAttributeMessage(buffer.m_130259_(), (DisplayAttributeType)buffer.m_130066_(DisplayAttributeType.class), buffer.readBoolean(), buffer.readInt());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.displayAttributeType);
        buffer.writeBoolean(this.booleanValue.booleanValue());
        buffer.writeInt(this.integerValue.intValue());
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.displayAttributeType == null) {
            log.error("Invalid entity attribute for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.booleanValue == null && this.integerValue == null) {
            log.error("Invalid value for {} for {} from {}", (Object)this.displayAttributeType, easyNPC, (Object)serverPlayer);
            return;
        }
        DisplayAttributeData<?> displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData == null) {
            log.error("Unable to get display attribute data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DisplayAttributeSet displayAttributeSet = displayAttributeData.getDisplayAttributeSet();
        if (displayAttributeSet == null) {
            log.error("Unable to get display attribute set for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DisplayAttributeEntry displayAttributeEntry = new DisplayAttributeEntry(this.displayAttributeType, Boolean.TRUE.equals(this.booleanValue), this.integerValue);
        log.debug("Change display attribute {} for {} to {}", (Object)this.displayAttributeType, easyNPC, (Object)displayAttributeEntry);
        displayAttributeSet.addOrReplaceDisplayAttribute(displayAttributeEntry);
        displayAttributeData.updateDisplayAttributeSet();
        if (this.displayAttributeType == DisplayAttributeType.VISIBLE) {
            easyNPC.getEntity().m_6842_(Boolean.FALSE.equals(this.booleanValue));
        }
    }
}

