/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;

public record ChangeModelEquipmentVisibilityMessage(UUID uuid, EquipmentSlot equipmentSlot, boolean visible) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "change_model_equipment_visibility");

    public static ChangeModelEquipmentVisibilityMessage create(FriendlyByteBuf buffer) {
        return new ChangeModelEquipmentVisibilityMessage(buffer.m_130259_(), (EquipmentSlot)buffer.m_130066_(EquipmentSlot.class), buffer.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.equipmentSlot);
        buffer.writeBoolean(this.visible);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.equipmentSlot == null) {
            log.error("Invalid equipmentSlot for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} visibility to {} for {} from {}", (Object)this.equipmentSlot, (Object)this.visible, easyNPC, (Object)serverPlayer);
        switch (this.equipmentSlot) {
            case HEAD: {
                modelData.setModelHelmetVisible(this.visible);
                break;
            }
            case CHEST: {
                modelData.setModelChestplateVisible(this.visible);
                break;
            }
            case LEGS: {
                modelData.setModelLeggingsVisible(this.visible);
                break;
            }
            case FEET: {
                modelData.setModelBootsVisible(this.visible);
                break;
            }
            default: {
                log.error("Invalid equipmentSlot {} for {} from {}", (Object)this.equipmentSlot, easyNPC, (Object)serverPlayer);
            }
        }
    }
}

