/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.Create;
import com.simibubi.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import com.simibubi.create.api.behaviour.spouting.CauldronSpoutingBehavior;
import com.simibubi.create.api.behaviour.spouting.StateChangingBehavior;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.compat.tconstruct.SpoutCasting;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;

public class AllBlockSpoutingBehaviours {
    static void registerDefaults() {
        Predicate<Fluid> isWater = fluid -> fluid.m_6212_((Fluid)Fluids.f_76193_);
        BlockSpoutingBehaviour toMud = StateChangingBehavior.setTo(250, isWater, Blocks.f_220864_);
        for (Block dirt : List.of(Blocks.f_50493_, Blocks.f_50546_, Blocks.f_152549_)) {
            BlockSpoutingBehaviour.BY_BLOCK.register(dirt, toMud);
        }
        BlockSpoutingBehaviour.BY_BLOCK.register(Blocks.f_50093_, StateChangingBehavior.incrementingState(100, isWater, FarmBlock.f_53243_));
        BlockSpoutingBehaviour.BY_BLOCK.register(Blocks.f_152476_, StateChangingBehavior.incrementingState(250, isWater, LayeredCauldronBlock.f_153514_));
        BlockSpoutingBehaviour.BY_BLOCK.register(Blocks.f_50256_, CauldronSpoutingBehavior.INSTANCE);
        if (!Mods.TCONSTRUCT.isLoaded()) {
            return;
        }
        for (String name : List.of("table", "basin")) {
            ResourceLocation id = Mods.TCONSTRUCT.rl(name);
            if (ForgeRegistries.BLOCK_ENTITY_TYPES.containsKey(id)) {
                BlockEntityType table = (BlockEntityType)ForgeRegistries.BLOCK_ENTITY_TYPES.getValue(id);
                BlockSpoutingBehaviour.BY_BLOCK_ENTITY.register(table, SpoutCasting.INSTANCE);
                continue;
            }
            Create.LOGGER.warn("Block entity {} wasn't found. Outdated compat?", (Object)id);
        }
    }
}

